implementation module menuitems


import	StdInt, StdBool, StdMisc
import	osmenu
import	id, menucreate
// RWS +++
import commondef

/*	Adding menu elements to (Sub)Menus:
		Items in a (sub)menu are positioned starting from 1 and increasing by 1.
		Open with a position less than 1 adds the new elements in front.
		Open with a position higher than the number of items adds the new elements to the end.
		Open an item on a position adds the item AFTER the item on that position.
	The (Id,Maybe Id) argument indicates where the elements should be added. 
		In case the Maybe Id argument is Nothing, then the elements should be added to the Menu indicated by the Id component. 
		In case the Maybe Id argument is Just id, then the elements should be added to the SubMenu indicated by id.
*/
addMenusItems :: !(!Id,Maybe Id) Int .ls` (m .ls` (PSt .l .p)) SystemId ReceiverTable !(MenuHandles (PSt .l .p)) !*OSToolbox
													 -> (!(!ErrorReport,ReceiverTable),!MenuHandles (PSt .l .p), !*OSToolbox)
													 |  MenuElements m
addMenusItems loc pos ls new pid rt menus=:{mMenus,mKeys} tb
	# (error,_,rt,mHs,keys,tb)	= addMenusItems` loc pos ls new pid rt mMenus mKeys tb
	= ((error,rt),{menus & mMenus=mHs,mKeys=keys}, tb)
where
	addMenusItems` :: !(!Id,Maybe Id) Int .ls` (m .ls` (PSt .l .p)) SystemId ReceiverTable ![MenuStateHandle (PSt .l .p)] ![Char] !*OSToolbox
													   -> (!ErrorReport,.ls`,ReceiverTable,![MenuStateHandle (PSt .l .p)],![Char],!*OSToolbox)
													   |  MenuElements m
	addMenusItems` loc pos ls new pid rt [MenuLSHandle mlsH=:{mlsHandle}:mHs] keys tb
		# (opened,error,ls,rt,mlsHandle,keys,tb)= addMenuItems loc pos ls new pid rt mlsHandle keys tb
		  mH									= MenuLSHandle {mlsH & mlsHandle=mlsHandle}
		| opened
		= (error,ls,rt,[mH:mHs],keys,tb)
		# (error,ls,rt,    mHs, keys,tb)		= addMenusItems` loc pos ls new pid rt mHs keys tb
		= (error,ls,rt,[mH:mHs],keys,tb)
	where
		addMenuItems :: !(!Id,Maybe Id) Int .ls` (m .ls` (PSt .l .p)) SystemId ReceiverTable !(MenuHandle .ls (PSt .l .p)) ![Char] !*OSToolbox
												   -> (!Bool,!ErrorReport,.ls`,ReceiverTable, !MenuHandle .ls (PSt .l .p), ![Char],!*OSToolbox)
												   |  MenuElements m
		addMenuItems (mId,itemId) pos ls new pid rt mH=:{mHandle,mMenuId,mItems} keys tb
			| mId<>mMenuId
				= (False,NoError,ls,rt,mH,keys,tb)
			| isJust itemId
				= (True,error,ls1,rt1,{mH & mItems=items1},keys1,tb1)
				with
					(_,error,ls1,rt1,items1,keys1,_,tb1)= addSubMenuItems` mId (fromJust itemId) pos mHandle ls new pid rt mItems keys 1 tb
			# (_,error,ls,rt,itemHs,keys,_,_,tb)	= extendMenu` mId mHandle ls new pid rt mItems keys pos 1 tb
			| otherwise
				= (True,error,ls,rt,{mH & mItems=itemHs},keys,tb)
		where
			addSubMenuItems` :: !Id !Id !Int !OSMenu .ls` !(m .ls` (PSt .l .p)) !SystemId
														 !ReceiverTable ![MenuElementHandle .ls (PSt .l .p)] ![Char] !Int !*OSToolbox
							 -> (!Bool,!ErrorReport,.ls`,!ReceiverTable,![MenuElementHandle .ls (PSt .l .p)],![Char],!Int,!*OSToolbox)
							 |  MenuElements m
			addSubMenuItems` menuId itemId pos menu ls new pid rt [item:items] keys iNr tb
				# (opened,error,ls,rt,item,keys,iNr,tb)	= addSubMenuItems menuId itemId pos menu ls new pid rt item keys iNr tb
				| opened
					= (opened,error,ls,rt,[item:items],keys,iNr,tb)
				# (opened,error,ls,rt,items,keys,iNr,tb)= addSubMenuItems` menuId itemId pos menu ls new pid rt items keys iNr tb
				| otherwise
					= (opened,error,ls,rt,[item:items],keys,iNr,tb)
			addSubMenuItems` _ _ _ _ ls _ _ rt _ keys iNr tb
				= (False,NoError,ls,rt,[],keys,iNr,tb)
			
			addSubMenuItems :: !Id !Id !Int !OSMenu .ls` !(m .ls` (PSt .l .p)) !SystemId
														!ReceiverTable !(MenuElementHandle .ls (PSt .l .p)) ![Char] !Int !*OSToolbox
							-> (!Bool,!ErrorReport,.ls`,!ReceiverTable, !MenuElementHandle .ls (PSt .l .p), ![Char],!Int,!*OSToolbox)
							|  MenuElements m
			addSubMenuItems menuId itemId pos menu ls new pid rt (SubMenuHandle subH=:{mSubHandle,mSubMenuId,mSubItems}) keys iNr tb
				| isNothing mSubMenuId || itemId<>fromJust mSubMenuId
					= (opened,error,ls1,rt1,SubMenuHandle subH1,keys1,iNr+1,tb1)
					with
						(opened,error,ls1,rt1,items1,keys1,_,tb1)	= addSubMenuItems` menuId itemId pos mSubHandle ls new pid rt mSubItems keys 1 tb
						subH1										= {subH & mSubItems=items1}
				# (_,error,ls,rt,itemHs,keys,_,_,tb)				= extendMenu` menuId mSubHandle ls new pid rt mSubItems keys pos 1 tb
				  subH												= {subH & mSubItems=itemHs}
				| otherwise
					= (True,error,ls,rt,SubMenuHandle subH,keys,iNr+1,tb)
			addSubMenuItems _ _ _ _ ls _ _ rt itemH=:(RadioMenuHandle {mRadioItems}) keys iNr tb
				= (False,NoError,ls,rt,itemH,keys,iNr+length mRadioItems,tb)
			addSubMenuItems menuId itemId pos menu ls new pid rt (MenuListLSHandle mListItems) keys iNr tb
				# (opened,error,ls,rt,mListItems,keys,iNr,tb)	= addSubMenuItems` menuId itemId pos menu ls new pid rt mListItems keys iNr tb
				= (opened,error,ls,rt,MenuListLSHandle mListItems,keys,iNr,tb)
			addSubMenuItems menuId itemId pos menu ls new pid rt (MenuExtendLSHandle mH=:{mExtendItems}) keys iNr tb
				# (opened,error,ls,rt,mExtendItems,keys,iNr,tb)	= addSubMenuItems` menuId itemId pos menu ls new pid rt mExtendItems keys iNr tb
				= (opened,error,ls,rt,MenuExtendLSHandle {mH & mExtendItems=mExtendItems},keys,iNr,tb)
			addSubMenuItems menuId itemId pos menu ls new pid rt (MenuChangeLSHandle mH=:{mChangeItems}) keys iNr tb
				# (opened,error,ls,rt,mChangeItems,keys,iNr,tb)	= addSubMenuItems` menuId itemId pos menu ls new pid rt mChangeItems keys iNr tb
				= (opened,error,ls,rt,MenuChangeLSHandle {mH & mChangeItems=mChangeItems},keys,iNr,tb)
			addSubMenuItems _ _ _ _ ls _ _ rt itemH keys iNr tb
				= (False,NoError,ls,rt,itemH,keys,iNr+1,tb)
			
			extendMenu` :: !Id !OSMenu .ls` (m .ls` (PSt .l .p)) !SystemId
													!ReceiverTable ![MenuElementHandle .ls (PSt .l .p)] [Char] !Int !Int !*OSToolbox
						-> (!Bool,!ErrorReport,.ls`,!ReceiverTable,![MenuElementHandle .ls (PSt .l .p)],[Char],!Int,!Int,!*OSToolbox)
						|  MenuElements m
			extendMenu` menuId menu ls new pid rt itemHs keys 0 iNr tb
				# newItemHs			= menuElementToHandles {newLS=ls,newDef=new}
				  newItemHs			= map MenuElementStateToMenuElementHandle newItemHs
				  (ok,newItemHs,rt)	= menuIdsAreConsistent pid menuId newItemHs rt
				| not ok
					= (True,ErrorIdsInUse,undef,rt,itemHs,keys,pos,iNr,tb)
				# (itemHs,keys,tb)	= extendMenu menu (iNr-1) newItemHs itemHs keys tb
				| otherwise
					= (True,NoError,undef,rt,itemHs,keys,pos,iNr,tb)
			extendMenu` _ _ ls _ _ rt [] keys pos iNr tb
				= (False,NoError,ls,rt,[],keys,pos,iNr,tb)
			extendMenu` menuId menu ls new pid rt [itemH=:(MenuItemHandle _):itemHs] keys pos iNr tb
				# (opened,error,ls,rt,itemHs,keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs keys (pos-1) (iNr+1) tb
				= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
			extendMenu` menuId menu ls new pid rt [itemH=:(MenuReceiverHandle _):itemHs] keys pos iNr tb
				# (opened,error,ls,rt,itemHs,keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs keys pos iNr tb
				= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
			extendMenu` menuId menu ls new pid rt [itemH=:(SubMenuHandle _):itemHs] keys pos iNr tb
				# (opened,error,ls,rt,itemHs,keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs keys (pos-1) (iNr+1) tb
				= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
			extendMenu` menuId menu ls new pid rt [itemH=:(RadioMenuHandle {mRadioItems}):itemHs] keys pos iNr tb
				# (opened,error,ls,rt,itemHs,keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs keys (pos-1) (iNr+length mRadioItems) tb
				= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
			extendMenu` menuId menu ls new pid rt [itemH=:(MenuSeparatorHandle _):itemHs] keys pos iNr tb
				# (opened,error,ls,rt,itemHs,keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs keys (pos-1) (iNr+1) tb
				= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
			extendMenu` menuId menu ls new pid rt [MenuListLSHandle itemHs`:itemHs] keys pos iNr tb
				# (opened,error,ls,rt,itemHs`,keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs` keys pos iNr tb
				  itemH											= MenuListLSHandle itemHs`
				| opened
					= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
				# (opened,error,ls,rt,itemHs, keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs  keys pos iNr tb
				| otherwise
					= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
			extendMenu` menuId menu ls new pid rt [MenuExtendLSHandle mExH=:{mExtendItems=itemHs`}:itemHs] keys pos iNr tb
				# (opened,error,ls,rt,itemHs`,keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs` keys pos iNr tb
				  itemH											= MenuExtendLSHandle {mExH & mExtendItems=itemHs`}
				| opened
					= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
				# (opened,error,ls,rt,itemHs, keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs keys pos iNr tb
				| otherwise
					= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
			extendMenu` menuId menu ls new pid rt [MenuChangeLSHandle mChH=:{mChangeItems=itemHs`}:itemHs] keys pos iNr tb
				# (opened,error,ls,rt,itemHs`,keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs` keys pos iNr tb
				  itemH											= MenuChangeLSHandle {mChH & mChangeItems=itemHs`}
				| opened
					= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
				# (opened,error,ls,rt,itemHs, keys,pos,iNr,tb)	= extendMenu` menuId menu ls new pid rt itemHs  keys pos iNr tb
				| otherwise
				= (opened,error,ls,rt,[itemH:itemHs],keys,pos,iNr,tb)
	addMenusItems` _ _ ls _ _ rt mHs keys tb
		= (ErrorUnknownObject,ls,rt,mHs,keys,tb)


/*	Adding radio menu items to RadioMenus:
		Items in a RadioMenu are positioned starting from 1 and increasing by 1.
		Open with a position less than 1 adds the new elements in front.
		Open with a position higher than the number of items adds the new elements to the end.
		Open an item on a position adds the item AFTER the item on that position.
	The (Id,Id) argument indicates where the elements should be added. 
		The first Id indicates the Menu, the second Id indicates the RadioMenu.
*/
addMenuRadioItems :: !(!Id,Id) !Int [MenuRadioItem (PSt .l .p)] !(MenuHandles (PSt .l .p)) !*OSToolbox
											   -> (!ErrorReport, !MenuHandles (PSt .l .p), !*OSToolbox)
addMenuRadioItems loc pos new menus=:{mMenus,mKeys} tb
	# (error,mHs,keys,tb)	= addMenusItems` loc pos new mMenus mKeys tb
	= (error,{menus & mMenus=mHs,mKeys=keys}, tb)
where
	addMenusItems` :: !(!Id,Id) !Int [MenuRadioItem .ps] ![MenuStateHandle .ps] ![Char] !*OSToolbox
										-> (!ErrorReport,![MenuStateHandle .ps],![Char],!*OSToolbox)
	addMenusItems` loc pos new [MenuLSHandle mlsH=:{mlsHandle}:mHs] keys tb
		# (opened,error,mlsHandle,keys,tb)	= addMenuItems loc pos new mlsHandle keys tb
		  mH								= MenuLSHandle {mlsH & mlsHandle=mlsHandle}
		| opened
			= (error,[mH:mHs],keys,tb)
		# (error,mHs,keys,tb)				= addMenusItems` loc pos new mHs keys tb
		| otherwise
			= (error,[mH:mHs],keys,tb)
	where
		addMenuItems :: !(!Id,Id) !Int [MenuRadioItem .ps] !(MenuHandle .ls .ps) ![Char] !*OSToolbox
									 -> (!Bool,!ErrorReport,!MenuHandle .ls .ps, ![Char],!*OSToolbox)
		addMenuItems (mId,itemId) pos new mH=:{mHandle,mMenuId,mItems} keys tb
			| mId<>mMenuId
				= (False,NoError,mH,keys,tb)
			# (_,error,itemHs,keys,_,tb)	= addSubMenuItems` itemId pos mHandle new mItems keys 1 tb
			  mH							= {mH & mItems=itemHs}
			| otherwise
				= (True,error,mH,keys,tb)
		where
			addSubMenuItems` :: !Id !Int !OSMenu [MenuRadioItem .ps] ![MenuElementHandle .ls .ps] ![Char] !Int !*OSToolbox
											  -> (!Bool,!ErrorReport,![MenuElementHandle .ls .ps],![Char],!Int,!*OSToolbox)
			addSubMenuItems` itemId pos menu new [itemH:itemHs] keys iNr tb
				# (opened,error,itemH,sIds,iNr,tb)	= addSubMenuItems itemId pos menu new itemH keys iNr tb
				| opened
					= (opened,error,[itemH:itemHs],keys,iNr,tb)
				# (opened,error,itemHs,keys,iNr,tb)= addSubMenuItems` itemId pos menu new itemHs sIds iNr tb
				| otherwise
					= (opened,error,[itemH:itemHs],keys,iNr,tb)
			addSubMenuItems` _ _ _ _ _ keys iNr tb
				= (False,ErrorUnknownObject,[],keys,iNr,tb)
			
			addSubMenuItems :: !Id !Int !OSMenu [MenuRadioItem .ps] !(MenuElementHandle .ls .ps) ![Char] !Int !*OSToolbox
											  -> (!Bool,!ErrorReport,!MenuElementHandle .ls .ps, ![Char],!Int,!*OSToolbox)
			addSubMenuItems itemId pos menu new (SubMenuHandle subH=:{mSubHandle,mSubItems}) keys iNr tb
				# (opened,error,itemHs,keys,_,tb)	= addSubMenuItems` itemId pos mSubHandle new mSubItems keys 1 tb
				= (opened,error,SubMenuHandle {subH & mSubItems=itemHs},keys,iNr+1,tb)
			addSubMenuItems itemId pos menu new itemH=:(RadioMenuHandle radioH=:{mRadioId,mRadioIndex,mRadioItems}) keys iNr tb
				# nrItems			= length mRadioItems
				| isNothing mRadioId || itemId<>fromJust mRadioId
					= (False,NoError,itemH,keys,iNr+nrItems,tb)
				# newItemHs			= map (\(a,b,c,f)->RadioMenuItemToMenuElementHandle (a,b,c,noLS f)) new
				  nrNewItems		= length newItemHs
				  pos				= SetBetween pos 0 nrItems
				  index				= if (pos<mRadioIndex) (mRadioIndex+nrNewItems) (max 1 mRadioIndex)
				# (itemHs,keys,tb)	= extendMenu` iNr pos menu newItemHs mRadioItems keys tb
				  radioH			= {radioH & mRadioIndex=index,mRadioItems=itemHs}
				| nrItems<>0
					= (True,NoError,RadioMenuHandle {radioH & mRadioIndex=index,mRadioItems=itemHs},keys,iNr+nrItems+nrNewItems,tb)
				# itemHandle		= (\(MenuItemHandle {mOSMenuItem})->mOSMenuItem) (itemHs!!(index-1))
				# tb				= OSMenuItemCheck True menu itemHandle tb
				| otherwise
					= (True,NoError,RadioMenuHandle {radioH & mRadioIndex=1,    mRadioItems=itemHs},keys,iNr+nrItems+nrNewItems,tb)
			addSubMenuItems itemId pos menu new (MenuListLSHandle mListItems) keys iNr tb
				# (opened,error,mListItems,keys,iNr,tb)	= addSubMenuItems` itemId pos menu new mListItems keys iNr tb
				= (opened,error,MenuListLSHandle mListItems,keys,iNr,tb)
			addSubMenuItems itemId pos menu new (MenuExtendLSHandle mH=:{mExtendItems}) keys iNr tb
				# (opened,error,mExtendItems,keys,iNr,tb)	= addSubMenuItems` itemId pos menu new mExtendItems keys iNr tb
				= (opened,error,MenuExtendLSHandle {mH & mExtendItems=mExtendItems},keys,iNr,tb)
			addSubMenuItems itemId pos menu new (MenuChangeLSHandle mH=:{mChangeItems}) keys iNr tb
				# (opened,error,mChangeItems,keys,iNr,tb)	= addSubMenuItems` itemId pos menu new mChangeItems keys iNr tb
				= (opened,error,MenuChangeLSHandle {mH & mChangeItems=mChangeItems},keys,iNr,tb)
			addSubMenuItems _ _ _ _ itemH=:(MenuReceiverHandle _) keys iNr tb
				= (False,NoError,itemH,keys,iNr,tb)
			addSubMenuItems _ _ _ _ itemH keys iNr tb
				= (False,NoError,itemH,keys,iNr+1,tb)
			
			extendMenu` :: !Int !Int !OSMenu ![MenuElementHandle .ls .ps]
						![MenuElementHandle .ls .ps] ![Char] !*OSToolbox
					-> (![MenuElementHandle .ls .ps],![Char],!*OSToolbox)
			extendMenu` iNr 0 menu new items keys tb
				= extendMenu menu (iNr-1) new items keys tb
			extendMenu` iNr position menu new [item:items] keys tb
				# (items,keys,tb) = extendMenu` (iNr+1) (position-1) menu new items keys tb
				= ([item:items],keys,tb)
			extendMenu` iNr position menu new items keys tb
				= extendMenu menu (iNr-1) new items keys tb
	addMenusItems` _ _ _ mHs keys tb
		= (ErrorUnknownObject,mHs,keys,tb)


//	Removing menu elements from (sub/radio)menus:

removeMenusItems :: !Id ![Id] !SystemId !ReceiverTable !(MenuHandles .ps) !*OSToolbox
									-> (!ReceiverTable, !MenuHandles .ps, !*OSToolbox)
removeMenusItems mId ids pid rt menus=:{mMenus,mKeys} tb
	# (rt,mHs,keys,tb)	= removeMenusItems` mId ids pid rt mMenus mKeys tb
	= (rt,{menus & mMenus=mHs,mKeys=keys},tb)
where
	removeMenusItems` :: !Id ![Id] !SystemId !ReceiverTable ![MenuStateHandle .ps] ![Char] !*OSToolbox
										 -> (!ReceiverTable,![MenuStateHandle .ps],![Char],!*OSToolbox)
	removeMenusItems` _ [] _ rt mHs keys tb
		= (rt,mHs,keys,tb)
	removeMenusItems` mId ids pid rt [MenuLSHandle mlsH=:{mlsHandle=mH=:{mMenuId}}:mHs] keys tb
		| mId<>mMenuId
			# (rt,mHs,keys,tb)	= removeMenusItems` mId ids pid rt mHs keys tb
			= (rt,[MenuLSHandle mlsH:mHs],keys,tb)
		| otherwise
			# (rt,_,mH,keys,tb)	= removeMenuItems pid rt ids mH keys tb
			= (rt,[MenuLSHandle {mlsH & mlsHandle=mH}:mHs],keys,tb)
	where
		removeMenuItems :: !SystemId !ReceiverTable ![Id] !(MenuHandle .ls .ps) ![Char] !*OSToolbox
								 -> (!ReceiverTable,![Id], !MenuHandle .ls .ps, ![Char],!*OSToolbox)
		removeMenuItems pid rt ids mH=:{mHandle,mItems} keys tb
			# (_,rt,ids,mItems,keys,tb) = removeFromMenu` mHandle pid 1 rt ids mItems keys tb
			= (rt,ids,{mH & mItems=mItems},keys,tb)
		where
			removeFromMenu` :: !OSMenu !SystemId !Int !ReceiverTable ![Id] ![MenuElementHandle .ls .ps] ![Char] !*OSToolbox
													-> (!Int,!ReceiverTable,![Id],![MenuElementHandle .ls .ps],![Char],!*OSToolbox)
			removeFromMenu` menu pid iNr rt ids items keys tb
				| isEmpty ids || isEmpty items
					= (iNr,rt,ids,items,keys,tb)
				# (item,items)						= HdTl items
				# (removed,iNr,rt,ids,item, keys,tb)= removeFromMenu  menu pid iNr rt ids item  keys tb
				# (        iNr,rt,ids,items,keys,tb)= removeFromMenu` menu pid iNr rt ids items keys tb
				| removed
					= (iNr,rt,ids,      items, keys,tb)
				| otherwise
					= (iNr,rt,ids,[item:items],keys,tb)
			
			removeFromMenu :: !OSMenu !SystemId !Int !ReceiverTable ![Id] !(MenuElementHandle .ls .ps) ![Char] !*OSToolbox
									  -> (!Bool,!Int,!ReceiverTable,![Id], !MenuElementHandle .ls .ps, ![Char],!*OSToolbox)
			removeFromMenu menu pid iNr rt ids itemH=:(SubMenuHandle subH=:{mSubHandle,mSubMenuId,mSubOSMenuNr,mSubItems}) keys tb
				# (containsItem,ids)		= if (isNothing mSubMenuId) (False,ids) (RemoveCheck (fromJust mSubMenuId) ids)
				# (_,rt,ids,itemHs,keys,tb)	= removeFromMenu` mSubHandle pid 1 rt ids mSubItems keys tb
				  itemH						= SubMenuHandle {subH & mSubItems=itemHs}
				| not containsItem
					= (containsItem,iNr+1,rt,ids,itemH,keys,tb)
				# rt						= StateMap2 (disposeMenuRIds pid) itemHs rt
				  keys						= StateMap2 disposeShortcutkeys   itemHs keys
				# tb						= StateMap2 disposeSubMenuHandles itemHs tb
				# (_,tb)					= OSSubMenuRemove mSubHandle menu tb
				| otherwise
					= (containsItem,iNr,rt,ids,itemH,keys,tb)
			removeFromMenu menu pid iNr rt ids (RadioMenuHandle radioH=:{mRadioId,mRadioIndex,mRadioItems}) keys tb
				# (containsItem,ids)		= if (isNothing mRadioId)
												(False,ids)
												(RemoveCheck (fromJust mRadioId) ids)
				  items						= confirmRadioMenuIndex mRadioIndex mRadioItems
				# (_,rt,ids,items,keys,tb)	= removeFromMenu` menu pid iNr rt ids items keys tb
				| containsItem
					# (keys,tb)				= StateMap2 (\(MenuItemHandle itemH)->disposeMenuItemHandle menu iNr itemH) items (keys,tb)
					# h						= RadioMenuHandle {radioH & mRadioItems=[]}
					= (containsItem,iNr,rt,ids,h,keys,tb)
				| otherwise
					# (index,items,tb)		= checkNewRadioMenuIndex menu iNr items tb
					  (nrNewItems,items)	= Ulength items
					  h						= RadioMenuHandle {radioH & mRadioItems=items,mRadioIndex=index}
				= (containsItem,iNr+nrNewItems,rt,ids,h,keys,tb)
			removeFromMenu menu pid iNr rt ids h=:(MenuItemHandle {mItemId,mItemKey,mOSMenuItem}) keys tb
				# (containsItem,ids)		= if (isNothing mItemId) (False,ids) (RemoveCheck (fromJust mItemId) ids)
				| not containsItem
					= (containsItem,iNr+1,rt,ids,h,keys,tb)
				# keys						= if (isJust mItemKey) [fromJust mItemKey:keys] keys
				# (_,tb)					= OSMenuRemoveItem mOSMenuItem menu tb
				| otherwise
					= (containsItem,iNr,rt,ids,h,keys,tb)
			removeFromMenu menu pid iNr rt ids h=:(MenuSeparatorHandle {mSepId,mOSMenuSeparator}) keys tb
				# (containsItem,ids)		= if (isNothing mSepId) (False,ids) (RemoveCheck (fromJust mSepId) ids)
				| not containsItem
					= (containsItem,iNr+1,rt,ids,h,keys,tb)
				# (_,tb)					= OSMenuRemoveItem mOSMenuSeparator menu tb
				| otherwise
					= (containsItem,iNr,rt,ids,h,keys,tb)
			removeFromMenu menu pid iNr rt ids h=:(MenuReceiverHandle {mReceiverHandle=rH=:{rId}}) keys tb
				# (containsItem,ids)		= RemoveCheck rId ids
				| not containsItem
					= (containsItem,iNr,rt,ids,h,keys,tb)
				# (_,rt)					= removeReceiverFromReceiverTable rId rt
				| otherwise
					= (containsItem,iNr,rt,ids,h,keys,tb)
			removeFromMenu menu pid iNr rt ids (MenuListLSHandle items) keys tb
				# (iNr,rt,ids,items,keys,tb)= removeFromMenu` menu pid iNr rt ids items keys tb
				= (False,iNr,rt,ids,MenuListLSHandle items,keys,tb)
			removeFromMenu menu pid iNr rt ids (MenuExtendLSHandle mH=:{mExtendItems=items}) keys tb
				# (iNr,rt,ids,items,keys,tb)= removeFromMenu` menu pid iNr rt ids items keys tb
				= (False,iNr,rt,ids,MenuExtendLSHandle {mH & mExtendItems=items},keys,tb)
			removeFromMenu menu pid iNr rt ids (MenuChangeLSHandle mH=:{mChangeItems=items}) keys tb
				# (iNr,rt,ids,items,keys,tb)= removeFromMenu` menu pid iNr rt ids items keys tb
				= (False,iNr,rt,ids,MenuChangeLSHandle {mH & mChangeItems=items},keys,tb)
	removeMenusItems` _ _ _ rt mHs=:[] keys tb
		= (rt,mHs,keys,tb)


/*	Removing menu elements from (sub/radio)menus by index (counting from 1):
	The second Boolean argument indicates whether the elements to be removed should be removed
		from RadioMenus (True) or (Sub)Menus (False).  
	The (Id,Maybe Id) argument indicates where the elements should be removed. 
		In case the Maybe Id argument is Nothing, then the elements should be removed from 
		the Menu indicated by the Id component. 
		In case the Maybe Id argument is Just id, then the elements should be removed from
		either a SubMenu or a RadioMenu identified by the Id component.
*/
removeMenusIndexItems :: !Bool !Bool !(!Id,!Maybe Id) ![Int] !SystemId !ReceiverTable !(MenuHandles .ps) !*OSToolbox
																   -> (!ReceiverTable, !MenuHandles .ps, !*OSToolbox)
removeMenusIndexItems alsoSpecials fromRadioMenu loc indices pid rt menus=:{mMenus,mKeys} tb
	# (rt,mHs,keys,tb)	= removeMenusIndexItems` alsoSpecials fromRadioMenu loc indices pid rt mMenus mKeys tb
	= (rt,{menus & mMenus=mHs,mKeys=keys},tb)
where
	removeMenusIndexItems` :: !Bool !Bool !(!Id,!Maybe Id) ![Int] !SystemId
								!ReceiverTable ![MenuStateHandle .ps] ![Char] !*OSToolbox
							-> (!ReceiverTable,![MenuStateHandle .ps],![Char],!*OSToolbox)
	removeMenusIndexItems` alsoSpecials fromRadioMenu loc=:(mId,itemId) indices pid rt [MenuLSHandle mlsH=:{mlsHandle=mH=:{mMenuId}}:mHs] keys tb
		| mId<>mMenuId
			# (rt,mHs,keys,tb)	= removeMenusIndexItems` alsoSpecials fromRadioMenu loc indices pid rt mHs keys tb
			= (rt,[MenuLSHandle mlsH:mHs],keys,tb)
		| otherwise
			# (_,rt,mH,keys,tb)	= removeMenuIndexItems alsoSpecials fromRadioMenu itemId indices pid rt mH keys tb
			= (rt,[MenuLSHandle {mlsH & mlsHandle=mH}:mHs],keys,tb)
	removeMenusIndexItems` _ _ _ _ _ rt mHs=:[] keys tb
		= (rt,mHs,keys,tb)
	
	removeMenuIndexItems :: !Bool !Bool !(Maybe Id) ![Int] !SystemId !ReceiverTable !(MenuHandle .ls .ps) ![Char] !*OSToolbox
														  -> (!Bool, !ReceiverTable, !MenuHandle .ls .ps, ![Char],!*OSToolbox)
	removeMenuIndexItems alsoSpecials fromRadioMenu itemId indices pid rt mH=:{mHandle,mItems} keys tb
		| isNothing itemId
			# (_,_,rt,mItems,keys,tb)	= removeItems` alsoSpecials mHandle pid 1 indices rt mItems keys tb
			= (True,rt,{mH & mItems=mItems},keys,tb)
		| otherwise
			# (done,_,rt,mItems,keys,tb)= removeIndexsFromMenu` alsoSpecials fromRadioMenu pid (fromJust itemId) indices mHandle 1 rt mItems keys tb
			= (done,rt,{mH & mItems=mItems},keys,tb)
	where
		removeIndexsFromMenu` :: !Bool !Bool !SystemId !Id ![Int] !OSMenu
								 !Int !ReceiverTable ![MenuElementHandle .ls .ps] ![Char] !*OSToolbox
					   -> (!Bool,!Int,!ReceiverTable,![MenuElementHandle .ls .ps],![Char],!*OSToolbox)
		removeIndexsFromMenu` alsoSpecials fromRadioMenu pid itemId indices menu iNr rt items keys tb
			| isEmpty items
				= (False,iNr,rt,items,keys,tb)
			# (item,items)					= HdTl items
			  (done,iNr,rt,item,keys,tb)	= removeIndexsFromMenu alsoSpecials fromRadioMenu pid itemId indices menu iNr rt item keys tb
			| done
				= (done,iNr,rt,[item:items],keys,tb)
			# (done,iNr,rt,items,keys,tb)	= removeIndexsFromMenu` alsoSpecials fromRadioMenu pid itemId indices menu iNr rt items keys tb
			| otherwise
				= (done,iNr,rt,[item:items],keys,tb)
		
		removeIndexsFromMenu :: !Bool !Bool !SystemId !Id ![Int] !OSMenu
								!Int !ReceiverTable !(MenuElementHandle .ls .ps) ![Char] !*OSToolbox
					  -> (!Bool,!Int,!ReceiverTable, !MenuElementHandle .ls .ps, ![Char],!*OSToolbox)
		removeIndexsFromMenu alsoSpecials fromRadioMenu pid itemId indices menu iNr rt 
												  (SubMenuHandle subH=:{mSubHandle,mSubMenuId,mSubItems}) keys tb
			| isJust mSubMenuId && itemId==fromJust mSubMenuId && not fromRadioMenu
				# (_,_,rt,items,keys,tb)	= removeItems` alsoSpecials mSubHandle pid 1 indices rt mSubItems keys tb
				= (True,iNr+1,rt,SubMenuHandle {subH & mSubItems=items},keys,tb)
			| otherwise
				# (done,_,rt,items,keys,tb)	= removeIndexsFromMenu` alsoSpecials fromRadioMenu pid itemId indices mSubHandle 1 rt mSubItems keys tb
				= (done,iNr+1,rt,SubMenuHandle {subH & mSubItems=items},keys,tb)
		removeIndexsFromMenu alsoSpecials fromRadioMenu pid itemId indices menu iNr rt 
												  (RadioMenuHandle radioH=:{mRadioId,mRadioIndex,mRadioItems}) keys tb
			| isNothing mRadioId || itemId<>fromJust mRadioId || not fromRadioMenu
				= (False,iNr,rt,RadioMenuHandle radioH,keys,tb)
			# iNrIndices						= map (\index->index+iNr-1) indices
			  items								= confirmRadioMenuIndex mRadioIndex mRadioItems
			# (_,_,rt,items,keys,tb)			= removeItems` alsoSpecials menu pid iNr iNrIndices rt items keys tb
			# (index,items,tb)					= checkNewRadioMenuIndex menu iNr items tb
			| otherwise
				= (True,iNr,rt,RadioMenuHandle {radioH & mRadioItems=items,mRadioIndex=index},keys,tb)
		removeIndexsFromMenu alsoSpecials fromRadioMenu pid itemId indices menu iNr rt (MenuListLSHandle mListItems) keys tb
			# (removed,iNr,rt,mListItems,keys,tb)	= removeIndexsFromMenu` alsoSpecials fromRadioMenu pid itemId indices menu iNr rt mListItems keys tb
			= (removed,iNr,rt,MenuListLSHandle mListItems,keys,tb)
		removeIndexsFromMenu alsoSpecials fromRadioMenu pid itemId indices menu iNr rt (MenuExtendLSHandle mH=:{mExtendItems}) keys tb
			# (removed,iNr,rt,mExtendItems,keys,tb)	= removeIndexsFromMenu` alsoSpecials fromRadioMenu pid itemId indices menu iNr rt mExtendItems keys tb
			= (removed,iNr,rt,MenuExtendLSHandle {mH & mExtendItems=mExtendItems},keys,tb)
		removeIndexsFromMenu alsoSpecials fromRadioMenu pid itemId indices menu iNr rt (MenuChangeLSHandle mH=:{mChangeItems}) keys tb
			# (removed,iNr,rt,mChangeItems,keys,tb)	= removeIndexsFromMenu` alsoSpecials fromRadioMenu pid itemId indices menu iNr rt mChangeItems keys tb
			= (removed,iNr,rt,MenuChangeLSHandle {mH & mChangeItems=mChangeItems},keys,tb)
		removeIndexsFromMenu _ _ _ _ _ _ iNr rt h sIds tb
			= (False,iNr+1,rt,h,sIds,tb)
		
		removeItems` :: !Bool !OSMenu !SystemId !Int ![Int] !ReceiverTable ![MenuElementHandle .ls .ps] ![Char] !*OSToolbox
											-> (!Int,![Int],!ReceiverTable,![MenuElementHandle .ls .ps],![Char],!*OSToolbox)
		removeItems` alsoSpecials menu pid iNr indices rt items keys tb
			| isEmpty indices || isEmpty items
				= (iNr,indices,rt,items,keys,tb)
			# (item,items)							= HdTl items
			# (removed,iNr,indices,rt,item, keys,tb)= removeItems  alsoSpecials menu pid iNr indices rt item  keys tb
			# (        iNr,indices,rt,items,keys,tb)= removeItems` alsoSpecials menu pid iNr indices rt items keys tb
			| removed
				= (iNr,indices,rt,      items, keys,tb)
			| otherwise
				= (iNr,indices,rt,[item:items],keys,tb)
		
		removeItems :: !Bool !OSMenu !SystemId !Int ![Int] !ReceiverTable !(MenuElementHandle .ls .ps) ![Char] !*OSToolbox
									 -> (!Bool,!Int,![Int],!ReceiverTable, !MenuElementHandle .ls .ps, ![Char],!*OSToolbox)
		removeItems alsoSpecials menu pid iNr indices rt itemH=:(SubMenuHandle subH=:{mSubHandle,mSubMenuId,mSubOSMenuNr,mSubItems}) keys tb
			# (containsItem,indices)= RemoveCheck iNr indices
			| not containsItem || (specialId && not alsoSpecials)
				= (False,iNr+1,indices,rt,itemH,keys,tb)
			# rt					= StateMap2 (disposeMenuRIds pid) mSubItems rt
			  keys					= StateMap2 disposeShortcutkeys   mSubItems keys
			# tb					= StateMap2	disposeSubMenuHandles mSubItems tb
			# (_,tb)				= OSSubMenuRemove mSubHandle menu tb
			# indices				= map dec indices
			| otherwise
				= (containsItem,iNr,indices,rt,itemH,keys,tb)
		where
			specialId				= isJust mSubMenuId && isSpecialId (fromJust mSubMenuId)
		removeItems alsoSpecials menu pid iNr indices rt (RadioMenuHandle radioH=:{mRadioId,mRadioItems}) keys tb
			# (containsItem,indices)= RemoveCheck iNr indices
			| not containsItem || (specialId && not alsoSpecials)
				# (nrItems,items)	= Ulength mRadioItems
				  itemH				= RadioMenuHandle {radioH & mRadioItems=items}
				  indices			= map ((+) (nrItems-1)) indices
				= (False,iNr+nrItems,indices,rt,itemH,keys,tb)
			| otherwise
				# (keys,tb)			= StateMap2 (\(MenuItemHandle itemH)->disposeMenuItemHandle menu iNr itemH) mRadioItems (keys,tb)
				  itemH				= RadioMenuHandle {radioH & mRadioItems=[]}
				  indices			= map dec indices
				= (containsItem,iNr,indices,rt,itemH,keys,tb)
		where
			specialId				= isJust mRadioId && isSpecialId (fromJust mRadioId)
		removeItems alsoSpecials menu pid iNr indices rt h=:(MenuItemHandle mH=:{mItemId,mItemKey,mOSMenuItem}) keys tb
			# (containsItem,indices)= RemoveCheck iNr indices
			| not containsItem || (specialId && not alsoSpecials)
				= (False,iNr+1,indices,rt,h,keys, tb)
			# (_,tb)				= OSMenuRemoveItem mOSMenuItem menu tb
			  keys					= case mItemKey of
			  							(Just key)	-> [key:keys]
			  							_			-> keys
			  indices				= map dec indices
			| otherwise
				= (containsItem,iNr,indices,rt,h,keys,tb)
		where
			specialId				= isJust mItemId && isSpecialId (fromJust mItemId)
		removeItems alsoSpecials menu pid iNr indices rt h=:(MenuSeparatorHandle {mSepId,mOSMenuSeparator}) keys tb
			# (containsItem,indices)= RemoveCheck iNr indices
			| not containsItem || (specialId && not alsoSpecials)
				= (False,iNr+1,indices,rt,h,keys,tb)
			# (_,tb)				= OSMenuRemoveItem mOSMenuSeparator menu tb
			# indices				= map dec indices
			| otherwise
				= (containsItem,iNr,indices,rt,h,keys,tb)
		where
			specialId				= isJust mSepId && isSpecialId (fromJust mSepId)
		removeItems alsoSpecials menu pid iNr indices rt itemH=:(MenuReceiverHandle recH=:{mReceiverHandle={rId}}) keys tb
			# (containsItem,indices)= RemoveCheck iNr indices
			| not containsItem
				= (False,iNr,indices,rt,itemH,keys,tb)
			# (_,rt)				= removeReceiverFromReceiverTable rId rt
			| otherwise
				= (containsItem,iNr,indices,rt,itemH,keys,tb)
		removeItems alsoSpecials menu pid iNr indices rt (MenuListLSHandle mListItems) keys tb
			# (iNr,indices,rt,mListItems,keys,tb) = removeItems` alsoSpecials menu pid iNr indices rt mListItems keys tb
			= (False,iNr,indices,rt,MenuListLSHandle mListItems,keys,tb)
		removeItems alsoSpecials menu pid iNr indices rt (MenuExtendLSHandle mH=:{mExtendItems}) keys tb
			# (iNr,indices,rt,items,keys,tb)	= removeItems` alsoSpecials menu pid iNr indices rt mExtendItems keys tb
			= (False,iNr,indices,rt,MenuExtendLSHandle {mH & mExtendItems=items},keys,tb)
		removeItems alsoSpecials menu pid iNr indices rt (MenuChangeLSHandle mH=:{mChangeItems}) keys tb
			# (iNr,indices,rt,items,keys,tb)	= removeItems` alsoSpecials menu pid iNr indices rt mChangeItems keys tb
			= (False,iNr,indices,rt,MenuChangeLSHandle {mH & mChangeItems=items},keys,tb)


/*	confirmRadioMenuIndex ensures that only the menu item at the index position in the list has a True mItemMark field (counted from 1).
*/
confirmRadioMenuIndex :: !Int ![MenuElementHandle .ls .ps] -> [MenuElementHandle .ls .ps]
confirmRadioMenuIndex i [MenuItemHandle itemH:itemHs]
	# itemHs	= confirmRadioMenuIndex (i-1) itemHs
	= [MenuItemHandle {itemH & mItemMark=i==1}:itemHs]
confirmRadioMenuIndex _ []
	= []

/*	checkNewRadioMenuIndex yields the Index of the first checked menu item in the list.
	If the list is empty, then 0 is returned and no menu item is checked.
	If there is no checked menu item then 1 is returned, and the first menu item (if
	present) in the list is checked.
*/
checkNewRadioMenuIndex :: !OSMenu !Int ![MenuElementHandle .ls .ps] !*OSToolbox -> (!Int,![MenuElementHandle .ls .ps],!*OSToolbox)
checkNewRadioMenuIndex menu iNr itemHs tb
	| isEmpty itemHs
		= (0,itemHs,tb)
	# (found,index,itemHs)	= getNewRadioMenuIndex 1 itemHs
	| found
		= (index,itemHs,tb)
	# (itemHs,tb)			= checkFirstRadioItem menu iNr itemHs tb
	| otherwise
		= (1,itemHs,tb)
where
	getNewRadioMenuIndex :: !Int ![MenuElementHandle .ls .ps] -> (!Bool,!Int,![MenuElementHandle .ls .ps])
	getNewRadioMenuIndex index [itemH=:(MenuItemHandle {mItemMark}):itemHs]
		| mItemMark
			= (mItemMark,index,[itemH:itemHs])
		# (found,index,itemHs)	= getNewRadioMenuIndex (index+1) itemHs
		| otherwise
			= (found,index,[itemH:itemHs])
	getNewRadioMenuIndex index []
		= (False,index,[])
	
	checkFirstRadioItem :: !OSMenu !Int ![MenuElementHandle .ls .ps] !*OSToolbox -> (![MenuElementHandle .ls .ps],!*OSToolbox)
	checkFirstRadioItem menu iNr [MenuItemHandle itemH=:{mOSMenuItem}:itemHs] tb
		= ([MenuItemHandle {itemH & mItemMark=True}:itemHs],OSMenuItemCheck True menu mOSMenuItem tb)
	checkFirstRadioItem _ _ [] tb
		= ([],tb)
